#ifndef _D2PIO_SOURCE_CMDS_H_
#define _D2PIO_SOURCE_CMDS_H_

//#define TARGET_OS_D2P 1

/***************************************************************************************************/
//
// This file contains declarations for parameter and response structures used by the function 
// D2PIO_Device_SendCmdAndGetResponse().
//
/***************************************************************************************************/
//
// General D2PIO commands include:
//
#define D2PIO_CMD_ID_GET_STATUS 0x10
#define D2PIO_CMD_ID_START_MEASUREMENTS 0x18
#define D2PIO_CMD_ID_STOP_MEASUREMENTS 0x19
#define D2PIO_CMD_ID_INIT 0x1A
#define D2PIO_CMD_ID_SET_MEASUREMENT_PERIOD 0x1B
#define D2PIO_CMD_ID_GET_MEASUREMENT_PERIOD 0x1C
#define D2PIO_CMD_ID_SET_LED_STATE 0x1D
#define D2PIO_CMD_ID_GET_LED_STATE 0x1E

#define D2PIO_CMD_ID_WRITE_NV_MEM 0x26	
#define D2PIO_CMD_ID_READ_NV_MEM 0x27

#define D2PIO_CMD_ID_CLEAR_ERROR_FLAGS 0x34

#define D2PIO_CMD_ID_SET_FINITE_COLLECTION_PARAMS  0x35
#define D2PIO_CMD_ID_GET_FINITE_COLLECTION_PARAMS  0x36
#define D2PIO_CMD_ID_CLEAR_FINITE_COLLECTION_PARAMS  0x37
#define D2PIO_CMD_ID_GET_FINITE_COLLECTION_STATUS  0x38

#define D2PIO_CMD_ID_START_FINITE_COLLECTION_RETRIEVAL 0x39
#define D2PIO_CMD_ID_STOP_FINITE_COLLECTION_RETRIEVAL 0x3A

#define D2PIO_CMD_ID_GET_SENSOR_CHANNEL_INFO 0x50
#define D2PIO_CMD_ID_GET_SENSOR_CHANNELS_AVAILABLE_MASK 0x51
#define D2PIO_CMD_ID_SET_TIME 0x52
#define D2PIO_CMD_ID_GET_TIME 0x53
#define D2PIO_CMD_ID_DISCONNECT 0x54
#define D2PIO_CMD_ID_GET_DEVICE_INFO 0x55
#define D2PIO_CMD_ID_GET_SENSOR_CHANNELS_DEFAULT_MASK  0x56
#define D2PIO_CMD_ID_SET_SENSOR_CHANNELS_DEFAULT_MASK  0x57
#define D2PIO_CMD_ID_IDENTIFY                          0x58

//D2PIO_CMD_ID_GET_BATTERY_LEVEL is only used for testing.
//It will not be supported in the final release of D2PIO. Use D2PIO_CMD_ID_GET_STATUS to query the battery level.
#define D2PIO_CMD_ID_GET_BATTERY_LEVEL 0x78

/***************************************************************************************************/

//See D2PIO_GetMeasurementChannelAvailabilityMask(), D2PIO_GetMeasurementChannelDefaultActivationMask() and D2PIO_IsChannelActive().
#define D2PIO_MAX_NUM_CHANNELS 32
#define D2PIO_MIN_VALID_CHANNEL_NUM 0
#define D2PIO_MAX_VALID_CHANNEL_NUM 31

/***************************************************************************************************/
//

#if defined(TARGET_OS_WIN) || defined(TARGET_OS_D2P)
#pragma pack(push)
#pragma pack(1)
#endif

#ifdef TARGET_OS_MAC
#pragma pack(1)
#endif

// The structures below define the parameter and response blocks associated with the commands defined above.
// Pointers to these structures are passed in to SendCmdAndGetResponse().
// If no parameter structure is defined for a command, then the command does not take parameters.
// If no response structure is defined for a command, then the only response associated with the command is D2PIODefaultCmdResponse.

#define D2PIO_STATUS_SUCCESS 0
#define D2PIO_STATUS_NOT_READY_FOR_NEW_CMD 0x30
#define D2PIO_STATUS_CMD_NOT_SUPPORTED 0x31
#define D2PIO_STATUS_INTERNAL_ERROR1 0x32
#define D2PIO_STATUS_INTERNAL_ERROR2 0x33
#define D2PIO_STATUS_ERROR_CANNOT_CHANGE_PERIOD_WHILE_COLLECTING 0x34
#define D2PIO_STATUS_ERROR_CANNOT_READ_NV_MEM_BLK_WHILE_COLLECTING_FAST 0x35
#define D2PIO_STATUS_ERROR_INVALID_PARAMETER 0x36
#define D2PIO_STATUS_ERROR_CANNOT_WRITE_FLASH_WHILE_COLLECTING 0x37
#define D2PIO_STATUS_ERROR_CANNOT_WRITE_FLASH_WHILE_HOST_FIFO_BUSY 0x38
#define D2PIO_STATUS_ERROR_OP_BLOCKED_WHILE_COLLECTING 0x39
#define D2PIO_STATUS_ERROR_CALCULATOR_CANNOT_MEASURE_WITH_NO_BATTERIES 0x3A
#define D2PIO_STATUS_ERROR_OP_NOT_SUPPORTED_IN_CURRENT_MODE 0x3B
#define D2PIO_STATUS_ERROR_AUDIO_CONTROL_FAILURE 0x3C
#define D2PIO_STATUS_ERROR_AUDIO_STREAM_FAILURE 0x3D
#define D2PIO_STATUS_ERROR_CANNOT_REALLOCATE_FRAME_BUFFERS 0x3E
#define D2PIO_STATUS_ERROR_COMMUNICATION 0x41
#define D2PIO_STATUS_ERROR_INVALID_EVENT_CONFIGURATION 0x42
#define D2PIO_STATUS_INTERNAL_ERROR3 0x48
#define D2PIO_STATUS_INTERNAL_ERROR4 0x49
#define D2PIO_STATUS_ERROR_TIMEOUT 0x50

//If SendCmdAndGetResponse() returns kResponse_Error and (1 == *pnRespBytes), then *pRespBuf contains
//D2PIODefaultCmdResponse, even if a different response structure is defined for the command.
//Note that if you only need to know whether or not SendCmdAndGetResponse() fails, but you do not care about why,
//then you can always set the pRespBuf paramter to NULL.
struct tagD2PIODefaultCmdResponse
{
	unsigned char status;//D2PIO_STATUS_...
};
typedef struct tagD2PIODefaultCmdResponse D2PIODefaultCmdResponse;

struct tagD2PIO_LittleEndian_int16
{
	unsigned char lsbyte;
	unsigned char msbyte;
};
typedef struct tagD2PIO_LittleEndian_int16 D2PIO_LittleEndian_int16;

struct tagD2PIO_LittleEndian_int32
{
	unsigned char lsbyteLsword;
	unsigned char msbyteLsword;
	unsigned char lsbyteMsword;
	unsigned char msbyteMsword;
}; 
typedef struct tagD2PIO_LittleEndian_int32 D2PIO_LittleEndian_int32;
typedef D2PIO_LittleEndian_int32 D2PIO_LittleEndian_uint32;

struct tagD2PIO_LittleEndian_int64
{
	unsigned char lsbyteLswordLsdword;
	unsigned char msbyteLswordLsdword;
	unsigned char lsbyteMswordLsdword;
	unsigned char msbyteMswordLsdword;
	unsigned char lsbyteLswordMsdword;
	unsigned char msbyteLswordMsdword;
	unsigned char lsbyteMswordMsdword;
	unsigned char msbyteMswordMsdword;
};
typedef struct tagD2PIO_LittleEndian_int64 D2PIO_LittleEndian_int64;
typedef D2PIO_LittleEndian_int64 D2PIO_LittleEndian_uint64;

struct tagD2PIO_LittleEndian_real32
{
	unsigned char byteArray[4];
};
typedef struct tagD2PIO_LittleEndian_real32 D2PIO_LittleEndian_real32;

struct tagD2PIO_LittleEndian_real64
{
	unsigned char byteArray[8];
};
typedef struct tagD2PIO_LittleEndian_real64 D2PIO_LittleEndian_real64;

/***************************************************************************************************/
//D2PIO_CMD_ID_SET_TIME:
//D2PIO_CMD_ID_GET_TIME:
struct tagD2PIOSetTimeParams
{
	D2PIO_LittleEndian_int64 timestamp;	//Microseconds since Jan 1 1970 Coordinated Universal Time(aka UTC aka Greenwich Mean Time)
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_SET_TIME.	*/
typedef struct tagD2PIOSetTimeParams D2PIOSetTimeParams;

typedef D2PIOSetTimeParams D2PIOGetTimeCmdResponsePayload;//This is the response payload returned by GetNextResponse() 
														//after sending D2PIO_CMD_ID_GET_TIME.

/***************************************************************************************************/
//D2PIO_CMD_ID_START_MEASUREMENTS
//D2PIO_CMD_ID_STOP_MEASUREMENTS
//If you call D2PIO_Device_SendCmdAndGetResponse(hDevice, D2PIO_CMD_ID_START_MEASUREMENTS, NULL,..) or D2PIO_Device_SendCmd(hDevice, D2PIO_CMD_ID_START_MEASUREMENTS, NULL,..),
//ie with the pParams argument set to NULL, then the D2PIO_lib will specify default parameters which tell the device to start measuring on all channels immediately.
//Similarly, D2PIO_Device_SendCmdAndGetResponse(hDevice, D2PIO_CMD_ID_STOP_MEASUREMENTS, NULL,..) will stop measurements on all channels.
struct tagD2PIOStartMeasurementsParams
{
	signed char channel;	/* -1 => all channels specified by channelBits.	*/
	unsigned char sampleAtTime0flag;
	unsigned char lsbyteLsword_channelBits;//Id's channels in the range from 0 to 7 that should start taking measurements. Ignored unless (channel == -1).
	unsigned char msbyteLsword_channelBits;//Id's channels in the range from 8 to 15 that should start taking measurements. Ignored unless (channel == -1).
	unsigned char lsbyteMsword_channelBits;//Id's channels in the range from 16 to 23 that should start taking measurements. Ignored unless (channel == -1).
	unsigned char msbyteMsword_channelBits;//Id's channels in the range from 24 to 31 that should start taking measurements. Ignored unless (channel == -1).
	D2PIO_LittleEndian_int64 startTimestamp;	//Microseconds since Jan 1 1970 Coordinated Universal Time(aka UTC aka Greenwich Mean Time), (timestamp == 0) => start immediately.
												//Finite collections interpret startTimestamp as the system time that D2PIO_CMD_ID_START_MEASUREMENTS was sent.
												//Finite collection measurement timestamps = startTimestamp + microseconds elapsed between receipt of CMD_ID_START and measurement.
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_START_MEASUREMENTS.	*/
typedef struct tagD2PIOStartMeasurementsParams D2PIOStartMeasurementsParams;

struct tagD2PIOStopMeasurementsParams
{
	signed char channel;	/* -1 => all channels specified by channelBits.	*/
	unsigned char spare;
	unsigned char lsbyteLsword_channelBits;//Id's channels in the range from 0 to 7 that should stop taking measurements. Ignored unless (channel == -1).
	unsigned char msbyteLsword_channelBits;//Id's channels in the range from 8 to 15 that should stop taking measurements. Ignored unless (channel == -1).
	unsigned char lsbyteMsword_channelBits;//Id's channels in the range from 16 to 23 that should stop taking measurements. Ignored unless (channel == -1).
	unsigned char msbyteMsword_channelBits;//Id's channels in the range from 24 to 31 that should stop taking measurements. Ignored unless (channel == -1).
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_STOP_MEASUREMENTS.	*/
typedef struct tagD2PIOStopMeasurementsParams D2PIOStopMeasurementsParams;

/***************************************************************************************************/
//D2PIO_CMD_ID_SET_MEASUREMENT_PERIOD:
//D2PIO_CMD_ID_GET_MEASUREMENT_PERIOD:
/*	The unit used for measurement periods and collection durations is a 'tick'. Each class of of hardware may define
	the meaning of a tick differently. For D2PIO, a 'tick' is one microsecond.										*/
struct tagD2PIOSetMeasurementPeriodParams
{
	signed char channel;	/* -1 => all channels.	*/
	unsigned char spare;
	D2PIO_LittleEndian_uint64 measurementPeriod; //In 'ticks', typically a tick == 1 microsecond
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_SET_MEASUREMENT_PERIOD.	*/
typedef struct tagD2PIOSetMeasurementPeriodParams D2PIOSetMeasurementPeriodParams;

typedef D2PIOSetMeasurementPeriodParams D2PIOSetMeasurementPeriodCmdResponsePayload;//This is the response payload returned by GetNextResponse() 
																					//after sending D2PIO_CMD_ID_SET_MEASUREMENT_PERIOD. 
																					//The meeasurementPeriod in the response is the closest value to that specified in the params that the device could actually implement.
struct tagD2PIOGetMeasurementPeriodParams
{
	signed char channel;	/* -1 => all channels.	*/
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_GET_MEASUREMENT_PERIOD.	*/
typedef struct tagD2PIOGetMeasurementPeriodParams D2PIOGetMeasurementPeriodParams;

typedef D2PIOSetMeasurementPeriodParams D2PIOGetMeasurementPeriodCmdResponsePayload;//This is the response payload returned by GetNextResponse() 
																					//after sending D2PIO_CMD_ID_GET_MEASUREMENT_PERIOD.

/***************************************************************************************************/
// The LED commands are supported by the LabQuest Mini, but not the LabQuest.
//D2PIO_CMD_ID_SET_LED_STATE:	
//D2PIO_CMD_ID_GET_LED_STATE:

#define D2PIO_LED_COLOR_BLACK 0xC0
#define D2PIO_LED_COLOR_RED 0x40
#define D2PIO_LED_COLOR_GREEN 0x80
#define D2PIO_LED_COLOR_RED_GREEN 0
#define D2PIO_LED_BRIGHTNESS_MIN 0
#define D2PIO_LED_BRIGHTNESS_MAX 0x10
#define D2PIO_LED_COLOR_ORANGE D2PIO_LED_COLOR_RED_GREEN
#define D2PIO_LED_BRIGHTNESS_ORANGE 4

struct tagD2PIOSetLedStateParams
{
	unsigned char LEDchannel;		//This parameter is ignored by the LabQuest Mini.
	unsigned char color;
	unsigned char brightness;
}; //Parameter block passed into SendCmd() with D2PIO_CMD_ID_SET_LED_STATE.
typedef struct tagD2PIOSetLedStateParams D2PIOSetLedStateParams;

struct tagD2PIOGetLedStateParams
{
	unsigned char LEDchannel;
}; //Parameter block passed into SendCmd() with D2PIO_CMD_ID_GET_LED_STATE.
typedef struct tagD2PIOGetLedStateParams D2PIOGetLedStateParams;

typedef D2PIOSetLedStateParams D2PIOGetLedStateCmdResponsePayload; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_LED_STATE.

/***************************************************************************************************/
//D2PIO_CMD_ID_GET_STATUS:
#define D2PIO_MASK_STATUS_ERROR_CMD_NOT_RECOGNIZED 1
#define D2PIO_MASK_STATUS_ERROR_CMD_IGNORED 2
#define D2PIO_MASK_STATUS_ADC_UNCALIBRATED 4
#define D2PIO_MASK_STATUS_AUTOID_UNCALIBRATED 8
#define D2PIO_MASK_STATUS_ERROR_INTERNAL_ERROR1 0X10
#define D2PIO_MASK_STATUS_ERROR_AUDIO_CONTROL_FAILURE 0X10
#define D2PIO_MASK_STATUS_ERROR_INTERNAL_ERROR2 0X20
#define D2PIO_MASK_STATUS_ERROR_AUDIO_STREAM_FAILURE 0X20
#define D2PIO_MASK_STATUS_ERROR_MASTER_FIFO_OVERFLOW 0X40
#define D2PIO_MASK_STATUS_ERROR_DIGITAL_TRANSITION_LOST 0X80

#define D2PIO_CHARGER_STATE_IDLE     0
#define D2PIO_CHARGER_STATE_CHARGING 1
#define D2PIO_CHARGER_STATE_COMPLETE 2
#define D2PIO_CHARGER_STATE_ERROR    3

struct tagD2PIOGetStatusCmdResponsePayload
{
	unsigned char status;	//See D2PIO_MASK_STATUS_*.
	unsigned char spare;
	unsigned char majorVersionMasterCPU;	//Binary coded decimal
	unsigned char minorVersionMasterCPU;	//Binary coded decimal
	unsigned char lsbyte_BuildNumMasterCPU;
	unsigned char msbyte_BuildNumMasterCPU;
	unsigned char majorVersionSlaveCPU;		//Binary coded decimal
	unsigned char minorVersionSlaveCPU;		//Binary coded decimal
	unsigned char lsbyte_BuildNumSlaveCPU;
	unsigned char msbyte_BuildNumSlaveCPU;
	unsigned char batteryLevelPercent;
	unsigned char chargerState;				//D2PIO_CHARGER_STATE_*
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_STATUS.
typedef struct tagD2PIOGetStatusCmdResponsePayload D2PIOGetStatusCmdResponsePayload;

/***************************************************************************************************/
//D2PIO_CMD_ID_GET_SENSOR_CHANNELS_AVAILABLE_MASK:

struct tagD2PIOGetSensorChannelsAvailableCmdResponse
{
	unsigned char lsbyteLsword_AvailableSensorChannels;//Availability bits for sensor channels 0 thru 7.
	unsigned char msbyteLsword_AvailableSensorChannels;//Availability bits for sensor channels 8 thru 15.
	unsigned char lsbyteMsword_AvailableSensorChannels;//Availability bits for sensor channels 16 thru 23.
	unsigned char msbyteMsword_AvailableSensorChannels;//Availability bits for sensor channels 24 thru 31.
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_SENSOR_CHANNELS_AVAILABLE_MASK.
typedef struct tagD2PIOGetSensorChannelsAvailableCmdResponse D2PIOGetSensorChannelsAvailableCmdResponse;

/***************************************************************************************************/
//D2PIO_CMD_ID_GET_SENSOR_CHANNEL_INFO:
#define	D2PIO_SAMPLING_MODE_PERIODIC 0
#define	D2PIO_SAMPLING_MODE_APERIODIC 1

#define D2PIO_NUMERIC_MEAS_TYPE_REAL64 0
#define D2PIO_NUMERIC_MEAS_TYPE_INT32 1

#define D2PIO_MAX_NUM_BYTES_IN_SENSOR_DESCRIPTION 60
#define D2PIO_MAX_NUM_BYTES_IN_SENSOR_UNIT 32

struct tagD2PIOGetSensorChannelInfoCmdResponse
{
	signed char channel;
	unsigned char spare;
	D2PIO_LittleEndian_uint32 sensorId;	//unique record key for the Sensor Map
	unsigned char numericMeasType;		//D2PIO_NUMERIC_MEAS_TYPE_...
	unsigned char samplingMode;			//D2PIO_SAMPLING_MODE_...
	char sensorDescription[D2PIO_MAX_NUM_BYTES_IN_SENSOR_DESCRIPTION];
	char sensorUnit[D2PIO_MAX_NUM_BYTES_IN_SENSOR_UNIT];
	D2PIO_LittleEndian_real64 measurementUncertainty;	//real number expressed in sensorUnit's.
	D2PIO_LittleEndian_real64 minMeasurement;			//real number expressed in sensorUnit's.
	D2PIO_LittleEndian_real64 maxMeasurement;			//real number expressed in sensorUnit's.
	D2PIO_LittleEndian_uint32 minMeasurementPeriod;		//in microsecond ticks
	D2PIO_LittleEndian_uint64 maxMeasurementPeriod;		//in microsecond ticks
	D2PIO_LittleEndian_uint32 typMeasurementPeriod;		//in microsecond ticks
	D2PIO_LittleEndian_uint32 measurementPeriodGranularity;	//in microsecond ticks, supported periods are integer multiples of measurementPeriodGranularity
	D2PIO_LittleEndian_uint32 mutualExclusionMask; //channels that cannot beenabled at the same time as this channel
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_SENSOR_CHANNEL_INFO.
typedef struct tagD2PIOGetSensorChannelInfoCmdResponse D2PIOGetSensorChannelInfoCmdResponse;

typedef D2PIOGetMeasurementPeriodParams D2PIOGetSensorChannelInfoParams;//Parameter block passed into SendCmd() with D2PIO_CMD_ID_GET_SENSOR_CHANNEL_INFO.

/***************************************************************************************************/
//D2PIO_CMD_ID_GET_DEVICE_INFO:

#define D2PIO_MAX_ORDERCODE_LENGTH 16
#define D2PIO_MAX_SERIALNUMBER_LENGTH 16
#define D2PIO_BLE_ADDRESS_LENGTH 6

struct tagD2PIOGetDeviceInfoCmdResponse
{
	char OrderCode[D2PIO_MAX_ORDERCODE_LENGTH];//NULL terminated UTF-8 string.
	char SerialNumber[D2PIO_MAX_SERIALNUMBER_LENGTH];//NULL terminated UTF-8 string.
	char DeviceName[32];//NULL terminated UTF-8 string. Reported to user by D2PIO_Device_GetOpenDeviceName(friendlyName).
	unsigned char lsbyte_ManufacturerId;
	unsigned char msbyte_ManufacturerId;
	unsigned char lsbyte_ManufacturedYear;
	unsigned char msbyte_ManufacturedYear;
	unsigned char ManufacturedMonth;
	unsigned char ManufacturedDay;
	unsigned char majorVersionMasterCPU;	//Binary coded decimal
	unsigned char minorVersionMasterCPU;	//Binary coded decimal
	unsigned char lsbyte_BuildNumMasterCPU;
	unsigned char msbyte_BuildNumMasterCPU;
	unsigned char majorVersionSlaveCPU;		//Binary coded decimal
	unsigned char minorVersionSlaveCPU;		//Binary coded decimal
	unsigned char lsbyte_BuildNumSlaveCPU;
	unsigned char msbyte_BuildNumSlaveCPU;
	unsigned char BLE_Address[D2PIO_BLE_ADDRESS_LENGTH];  // Raw binary, not NULL terminated string. Displays like this --> [5]:[4]:[3]:[2]:[1]:[0]
	D2PIO_LittleEndian_uint32 NVMemSize;
	char DeviceDescription[64];//NULL terminated UTF-8 string. Reported to user by D2PIO_Device_GetDeviceDescription().
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_DEVICE_INFO.
typedef struct tagD2PIOGetDeviceInfoCmdResponse D2PIOGetDeviceInfoCmdResponse;

/***************************************************************************************************/
//D2PIO_CMD_ID_READ_NV_MEM:
//D2PIO_CMD_ID_WRITE_NV_MEM:

struct tagD2PIOWriteNVMemParams
{
	signed char channel;//not currently used
	unsigned char lsbyteLswordAddr;
	unsigned char msbyteLswordAddr;
	unsigned char lsbyteMswordAddr;
	unsigned char msbyteMswordAddr;
	unsigned char count;
	unsigned char payload[1];	//The size of this payload varies. 
}; //Used with D2PIO_CMD_ID_WRITE_NV_MEM.
typedef struct tagD2PIOWriteNVMemParams D2PIOWriteNVMemParams;

struct tagD2PIOReadNVMemParams
{
	signed char channel;//not currently used
	unsigned char lsbyteLswordAddr;
	unsigned char msbyteLswordAddr;
	unsigned char lsbyteMswordAddr;
	unsigned char msbyteMswordAddr;
	unsigned char count;
}; //Used with D2PIO_CMD_ID_READ_NV_MEM.
typedef struct tagD2PIOReadNVMemParams D2PIOReadNVMemParams;

struct tagD2PIOReadNVMemCmdResponsePayload
{
	unsigned char payload[1];	//The size of this payload varies. 
}; //Used with D2PIO_CMD_ID_READ_NV_MEM.
typedef struct tagD2PIOReadNVMemCmdResponsePayload D2PIOReadNVMemCmdResponsePayload;


/***************************************************************************************************/
//D2PIO_CMD_ID_GET_SENSOR_ID: deprecated, see D2PIO_Device_GetMeasurementChannelSensorId().

struct tagD2PIOGetSensorIdParams
{
	signed char channel;	//D2PIO_CHANNEL_ID_ANALOG1 .. D2PIO_CHANNEL_ID_DIGITAL2
};			//Parameter block passed into SendCmd() with D2PIO_CMD_ID_GET_SENSOR_ID.
typedef struct tagD2PIOGetSensorIdParams D2PIOGetSensorIdParams;

struct tagD2PIOGetSensorIdCmdResponsePayload
{
	unsigned char lsbyteLswordSensorId;
	unsigned char msbyteLswordSensorId;
	unsigned char lsbyteMswordSensorId;
	unsigned char msbyteMswordSensorId;
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_SENSOR_ID.

typedef struct tagD2PIOGetSensorIdCmdResponsePayload D2PIOGetSensorIdCmdResponsePayload;

struct tagD2PIOGetSensorIdCmdResponseExtPayload
{
	unsigned char lsbyteLswordSensorId;
	unsigned char msbyteLswordSensorId;
	unsigned char lsbyteMswordSensorId;
	unsigned char msbyteMswordSensorId;
	unsigned char lsbyteLswordSIDSignature;//This increments every time the Sensor Id for the specified channel changes.
	unsigned char msbyteLswordSIDSignature;
	unsigned char lsbyteMswordSIDSignature;
	unsigned char msbyteMswordSIDSignature;
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_SENSOR_ID.

//D2PIOGetSensorIdCmdResponsePayloadExt is only supported in DAQ firmware versions >= 1.26 .
typedef struct tagD2PIOGetSensorIdCmdResponseExtPayload D2PIOGetSensorIdCmdResponseExtPayload;

struct tagD2PIOGetSensorIdCmdResponseExtListPayload
{
	D2PIOGetSensorIdCmdResponseExtPayload sensorElement[7];
}; //This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_SENSOR_ID with channel param == -1.

//D2PIOGetSensorIdCmdResponsePayloadExtList is only supported in DAQ firmware versions >= 1.26 .
//D2PIOGetSensorIdCmdResponseExtListPayload.sensorElement[0] is unused.
//D2PIOGetSensorIdCmdResponseExtListPayload.sensorElement[D2PIO_CHANNEL_ID_ANALOG1] is the first element with useful info.
typedef struct tagD2PIOGetSensorIdCmdResponseExtListPayload D2PIOGetSensorIdCmdResponseExtListPayload;

/***************************************************************************************************/
//D2PIO_CMD_ID_SET_SENSOR_CHANNEL_ENABLE_MASK: deprecated, see D2PIO_CMD_ID_START_MEASUREMENTS
//D2PIO_CMD_ID_GET_SENSOR_CHANNEL_ENABLE_MASK:

struct tagD2PIOSetSensorChannelEnableMaskParams
{
	unsigned char lsbyte_EnableSensorChannels;//Enable bits for sensor channels 0 thru 7.
	unsigned char msbyte_EnableSensorChannels;//Enable bits for sensor channels 8 thru 15.
}; //Used with D2PIO_CMD_ID_SET_SENSOR_CHANNEL_ENABLE_MASK.
typedef struct tagD2PIOSetSensorChannelEnableMaskParams D2PIOSetSensorChannelEnableMaskParams;

//This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_SENSOR_CHANNEL_ENABLE_MASK.
typedef D2PIOSetSensorChannelEnableMaskParams D2PIOGetSensorChannelEnableMaskCmdResponsePayload;

/***************************************************************************************************/
//D2PIO_CMD_ID_GET_BATTERY_LEVEL
//This will be deprecated. Use D2PIO_CMD_ID_GET_STATUS instead.
typedef struct
{
	unsigned char percent;	//Between 0 and 100 %
} D2PIOGetBatteryLevelCmdResponsePayload;//This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_BATTERY_LEVEL.

/***************************************************************************************************/
//D2PIO_CMD_ID_SET_SENSOR_CHANNELS_DEFAULT_MASK:
//D2PIO_CMD_ID_GET_SENSOR_CHANNELS_DEFAULT_MASK:

struct tagD2PIOSetSensorChannelsDefaultParams
{
	unsigned char lsbyteLsword_DefaultSensorChannels;//Default bits for sensor channels 0 thru 7.
	unsigned char msbyteLsword_DefaultSensorChannels;//Default bits for sensor channels 8 thru 15.
	unsigned char lsbyteMsword_DefaultSensorChannels;//Default bits for sensor channels 16 thru 23.
	unsigned char msbyteMsword_DefaultSensorChannels;//Default bits for sensor channels 24 thru 31.
}; //Parameter block passed into SendCmd() with D2PIO_CMD_ID_SET_SENSOR_CHANNELS_DEFAULT_MASK.
typedef struct tagD2PIOSetSensorChannelsDefaultParams D2PIOSetSensorChannelsDefaultParams;

typedef D2PIOSetSensorChannelsDefaultParams D2PIOGetSensorChannelsDefaultCmdResponse;

/***************************************************************************************************/
//D2PIO_CMD_ID_SET_FINITE_COLLECTION_PARAMS:
//D2PIO_CMD_ID_GET_FINITE_COLLECTION_PARAMS:
//D2PIO_CMD_ID_CLEAR_FINITE_COLLECTION_PARAMS: - takes no params and returns D2PIODefaultCmdResponse.

#define D2PIO_TRIGGER_CHAN_MODE_IMMEDIATE 0
#define D2PIO_TRIGGER_CHAN_MODE_LO_TO_HI_MEAS 1
#define D2PIO_TRIGGER_CHAN_MODE_HI_TO_LO_MEAS 2

struct tagD2PIOSetFiniteCollectionParams
{
	signed char triggerChannel;			
	unsigned char triggerChannelMode;			//D2PIO_TRIGGER_CHAN_MODE_...
	D2PIO_LittleEndian_uint32 finiteCollectionChannelMask;//identifies all the channels triggered by triggerChannel.
												//Bit for triggerChannel should be configured.
												//0 if D2PIO_CMD_ID_GET_FINITE_COLLECTION_PARAMS sent prior to D2PIO_CMD_ID_SET_FINITE_COLLECTION_PARAMS.
	D2PIO_LittleEndian_real64 triggerThreshold; //In units associated with triggerChannel.
	D2PIO_LittleEndian_real64 triggerHysteresis;//D2PIO_TRIGGER_CHAN_MODE_LO_TO_HI_MEAS => signal must be < (threshold - hysteresis) before
												//	testing against threshold.
												//D2PIO_TRIGGER_CHAN_MODE_HI_TO_LO_MEAS => signal must be > (threshold + hysteresis) before
												//	testing against threshold.
												//(triggerHysteresis < 0.0) for CMD_ID_SET_.. => device picks default.
	D2PIO_LittleEndian_uint32 numMeasurements;	//max num measurements to take for the triggerChannel.
	D2PIO_LittleEndian_uint32 numPreTriggerMeasurements;
	unsigned char queryOnlyFlag;//if nonzero, then device state is not changed by D2PIO_CMD_ID_SET_FINITE_COLLECTION_PARAMS.
	unsigned char spare1;
	unsigned char spare2;
	unsigned char spare3;
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_SET_FINITE_COLLECTION_PARAMS.	*/

typedef struct tagD2PIOSetFiniteCollectionParams D2PIOSetFiniteCollectionParams;

//This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_SET_FINITE_COLLECTION_PARAMS.
//The device responds with the closest set of values to the requested values that it can support.
typedef D2PIOSetFiniteCollectionParams D2PIOSetFiniteCollectionParamsCmdResponsePayload;

//This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_FINITE_COLLECTION_PARAMS.
typedef D2PIOSetFiniteCollectionParamsCmdResponsePayload D2PIOGetFiniteCollectionParamsCmdResponsePayload;

/***************************************************************************************************/
//D2PIO_CMD_ID_GET_FINITE_COLLECTION_STATUS:

#define D2PIO_FINITE_COLLECTION_STATUS_NOT_CONFIGURED 0
#define D2PIO_FINITE_COLLECTION_STATUS_READY_TO_COLLECT 1
#define D2PIO_FINITE_COLLECTION_STATUS_COLLECTING_PRETRIGGER 2
#define D2PIO_FINITE_COLLECTION_STATUS_COLLECTING_POSTTRIGGER 3
#define D2PIO_FINITE_COLLECTION_STATUS_COMPLETE 4

struct tagD2PIOGetFiniteCollectionStatusCmdResponsePayload
{
	unsigned char status;//D2PIO_FINITE_COLLECTION_STATUS_...		
	unsigned char triggerChannel;
	unsigned char triggerChannelMode;		//D2PIO_TRIGGER_CHAN_MODE_...
	unsigned char spare1;
	D2PIO_LittleEndian_uint32 finiteCollectionChannelMask;//0 until D2PIO_CMD_ID_START_MEASUREMENTS received.
	D2PIO_LittleEndian_uint32 numMeasurements;			//Num measurements taken for the triggerChannel.
	D2PIO_LittleEndian_uint32 numPreTriggerMeasurements;//Num measurements taken for triggerChannel prior to the trigger.

	D2PIO_LittleEndian_int64 startTimestamp;  //timestamp passed in with D2PIO_CMD_ID_START_MEASUREMENTS.
	D2PIO_LittleEndian_int64 triggerTimestamp;//microseconds between D2PIO_CMD_ID_START_MEASUREMENTS receipt and trigger detection = (triggerTimestamp - startTimestamp).
											  // < startTimestamp prior to detection of trigger.
	unsigned char spare2;
	unsigned char spare3;
	unsigned char spare4;
	unsigned char spare5;
};	//This is the response payload returned by GetNextResponse() after sending D2PIO_CMD_ID_GET_FINITE_COLLECTION_STATUS.

typedef struct tagD2PIOGetFiniteCollectionStatusCmdResponsePayload D2PIOGetFiniteCollectionStatusCmdResponsePayload;

/***************************************************************************************************/
//D2PIO_CMD_ID_START_FINITE_COLLECTION_RETRIEVAL:

struct tagD2PIOStartFiniteCollectionRetrievalParams
{
	D2PIO_LittleEndian_uint32 firstMeasurementIndex;//valid values are in the range 0 to (D2PIOGetFiniteCollectionParamsCmdResponsePayload.numMeasurements - 1).
	D2PIO_LittleEndian_uint32 maxNumMeasurements;	//Stop after sending this many measurements,
													//or after sending the last available measurement if status = D2PIO_FINITE_COLLECTION_STATUS_COMPLETE.
};	/* Parameter block passed into SendCmd() with D2PIO_CMD_ID_START_FINITE_COLLECTION_RETRIEVAL.	*/

//To retrieve everything, set (firstMeasurementIndex = 0) and (maxNumMeasurements = 0xffffffff).
typedef struct tagD2PIOStartFiniteCollectionRetrievalParams D2PIOStartFiniteCollectionRetrievalParams;

/***************************************************************************************************/

#if defined(TARGET_OS_WIN) || defined(TARGET_OS_D2P)
#pragma pack(pop)
#endif

#ifdef TARGET_OS_MAC
#pragma pack()
#endif


#endif //_D2PIO_SOURCE_CMDS_H_
